<?php
header("Content-Type: application/json");

require __DIR__ . '/classes/Database.php';

$db = new Database();
$pdo = $db->dbConnection();

$data = json_decode(file_get_contents("php://input"));

if (
    !isset($data->name) ||
    !isset($data->email) ||
    !isset($data->password)
) {
    echo json_encode([
        "status" => "error",
        "message" => "All fields required"
    ]);
    exit;
}

$name = trim($data->name);
$email = trim($data->email);
$password = $data->password;

// 🔐 Hash password
$password_hash = password_hash($password, PASSWORD_DEFAULT);

// Check if email exists
$stmt = $pdo->prepare("SELECT id FROM doctors WHERE email = :email");
$stmt->execute([":email" => $email]);

if ($stmt->rowCount() > 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Email already registered"
    ]);
    exit;
}

// ✅ Correct insert
$stmt = $pdo->prepare("
    INSERT INTO doctors (name, email, password_hash, phone, specialization)
    VALUES (:name, :email, :password_hash, NULL, NULL)
");

$stmt->execute([
    ":name" => $name,
    ":email" => $email,
    ":password_hash" => $password_hash
]);

echo json_encode([
    "status" => "success",
    "message" => "Doctor registered successfully"
]);
