<?php

class JwtHandler
{
    protected $secret_key;
    protected $issued_at;
    protected $expire;

    public function __construct()
    {
        $this->secret_key = "CHANGE_THIS_SECRET_KEY_123456";
        $this->issued_at = time();
        $this->expire = $this->issued_at + (60 * 60 * 24); // 24 hours
    }

    // Generate JWT
    public function jwtEncodeData($iss, $data)
    {
        $header = json_encode([
            "typ" => "JWT",
            "alg" => "HS256"
        ]);

        $payload = json_encode([
            "iss" => $iss,
            "iat" => $this->issued_at,
            "exp" => $this->expire,
            "data" => $data
        ]);

        $base64UrlHeader = $this->base64UrlEncode($header);
        $base64UrlPayload = $this->base64UrlEncode($payload);

        $signature = hash_hmac(
            "sha256",
            $base64UrlHeader . "." . $base64UrlPayload,
            $this->secret_key,
            true
        );

        $base64UrlSignature = $this->base64UrlEncode($signature);

        return $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;
    }

    // Decode JWT
    public function jwtDecodeData($jwt)
    {
        if (!$jwt) {
            return [
                "status" => false,
                "message" => "Token not provided"
            ];
        }

        $tokenParts = explode('.', $jwt);
        if (count($tokenParts) !== 3) {
            return [
                "status" => false,
                "message" => "Invalid token format"
            ];
        }

        $header = base64_decode($tokenParts[0]);
        $payload = base64_decode($tokenParts[1]);
        $signature_provided = $tokenParts[2];

        $payload_data = json_decode($payload);

        if ($payload_data->exp < time()) {
            return [
                "status" => false,
                "message" => "Token expired"
            ];
        }

        $base64UrlHeader = $this->base64UrlEncode($header);
        $base64UrlPayload = $this->base64UrlEncode($payload);

        $signature = hash_hmac(
            "sha256",
            $base64UrlHeader . "." . $base64UrlPayload,
            $this->secret_key,
            true
        );

        $base64UrlSignature = $this->base64UrlEncode($signature);

        if ($base64UrlSignature !== $signature_provided) {
            return [
                "status" => false,
                "message" => "Invalid token signature"
            ];
        }

        return [
            "status" => true,
            "data" => $payload_data->data
        ];
    }

    private function base64UrlEncode($data)
    {
        return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
    }
}
