<?php
// api/addDoctors.php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') { http_response_code(200); exit(); }

require __DIR__ . '/classes/Database.php';

try {
    $db = new Database();
    $pdo = $db->dbConnection();
    
    $data = json_decode(file_get_contents("php://input"));
    
    // VALIDATION LOGIC
    if(empty($data->name) || empty($data->specialization)) {
        echo json_encode(["status" => "error", "message" => "Name and Specialization are required."]);
        exit();
    }

    $email = $data->email ?? "";
    $phone = $data->phone ?? "";
    $pass = substr(str_shuffle("abcdef123456"), 0, 8); // Simple password

    // INSERT
    // Note: Ensure column name matches DB (is_available vs status)
    $sql = "INSERT INTO doctors (name, email, phone, specialization, role, status, password_hash) 
            VALUES (:name, :email, :phone, :spec, 'doctor', 1, :pass)";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':name' => $data->name,
        ':email' => $email,
        ':phone' => $phone,
        ':spec' => $data->specialization,
        ':pass' => password_hash($pass, PASSWORD_DEFAULT)
    ]);

    echo json_encode([
        "status" => "success", 
        "message" => "Doctor added!", 
        "generated_password" => $pass
    ]);

} catch (PDOException $e) {
    // CATCH SQL ERRORS
    echo json_encode(["status" => "error", "message" => "DB Error: " . $e->getMessage()]);
}
?>
