<?php
require __DIR__ . '/../classes/JwtHandler.php';

$headers = apache_request_headers();

if (!isset($headers['Authorization'])) {
    http_response_code(401);
    echo json_encode([
        "status" => "error",
        "message" => "Authorization token missing"
    ]);
    exit;
}

$token = trim(str_replace("Bearer", "", $headers['Authorization']));
$jwt = new JwtHandler();

$data = $jwt->jwtDecodeData($token);

if ($data['status'] === false) {
    http_response_code(401);
    echo json_encode([
        "status" => "error",
        "message" => "Invalid or expired token"
    ]);
    exit;
}

// Logged-in doctor ID (IMPORTANT)
$doctor_id = $data['data']->doctor_id;
