<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

require __DIR__ . '/classes/Database.php';
require __DIR__ . '/classes/JwtHandler.php';

$db_connection = new Database();
$pdo = $db_connection->dbConnection();
$jwt = new JwtHandler();

$data = json_decode(file_get_contents("php://input"));

if (!isset($data->email) || !isset($data->password)) {
    echo json_encode([
        "status" => "error",
        "message" => "Email and password required"
    ]);
    exit;
}

$email = trim($data->email);
$password = $data->password;

try {
    $stmt = $pdo->prepare("SELECT id, name, email, password_hash, phone, specialization FROM doctors WHERE email = :email LIMIT 1");
    $stmt->bindParam(":email", $email);
    $stmt->execute();

    if ($stmt->rowCount() === 0) {
        echo json_encode([
            "status" => "error",
            "message" => "User not found"
        ]);
        exit;
    }

    $doctor = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!password_verify($password, $doctor['password_hash'])) {
        echo json_encode([
            "status" => "error",
            "message" => "Invalid password"
        ]);
        exit;
    }

    // Generate JWT
    $token = $jwt->jwtEncodeData(
        "YOUR_SECRET_KEY",
        [
            "doctor_id" => $doctor['id'],
            "email" => $doctor['email']
        ]
    );

    echo json_encode([
        "status" => "success",
        "token" => $token,
        "doctor" => [
            "id" => $doctor['id'],
            "name" => $doctor['name'],
            "email" => $doctor['email'],
            "phone" => $doctor['phone'],
            "specialization" => $doctor['specialization'],
            // "license_number" => $doctor['license_number']
        ]
    ]);

} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => "Server error"
    ]);
}
