<?php
header("Content-Type: application/json");

require __DIR__ . '/../classes/Database.php';
require __DIR__ . '/../middleware/auth.php';

$db = new Database();
$pdo = $db->dbConnection();

$stmt = $pdo->prepare("
    SELECT id, name, age, condition 
    FROM patients 
    WHERE doctor_id = :doctor_id
");

$stmt->bindParam(":doctor_id", $doctor_id);
$stmt->execute();

$patients = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode([
    "status" => "success",
    "patients" => $patients
]);
