<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

require_once 'classes/Database.php';
$db = (new Database())->dbConnection();
$data = json_decode(file_get_contents("php://input"));

if(!empty($data->email) && !empty($data->password) && !empty($data->name)) {
    // Check if email exists
    $check = $db->prepare("SELECT id FROM admin WHERE email = ?");
    $check->execute([$data->email]);
    
    if($check->rowCount() > 0) {
        echo json_encode(["status" => "error", "message" => "Email already registered"]);
        exit;
    }

    // Insert New Doctor
    $sql = "INSERT INTO admin (name, email, password_hash, phone) VALUES (:name, :email, :pass, :phone)";
    $stmt = $db->prepare($sql);
    
    $hashed_pass = password_hash($data->password, PASSWORD_DEFAULT);
    
    if($stmt->execute([':name'=>$data->name, ':email'=>$data->email, ':pass'=>$hashed_pass, ':phone'=>$data->phone])) {
        echo json_encode(["status" => "success", "message" => "Registered successfully"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Registration failed"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Incomplete data"]);
}
?>
