<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

require_once 'classes/Database.php';

$database = new Database();
$db = $database->dbConnection();
$data = json_decode(file_get_contents("php://input"));

if(isset($data->email) && isset($data->password)) {
    // 1. Fetch the user
    $query = "SELECT * FROM admin WHERE email = :email LIMIT 1";
    $stmt = $db->prepare($query);
    $stmt->bindParam(":email", $data->email);
    $stmt->execute();

    if($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // 2. CHECK: Does the column 'password' exist? Or is it 'password_hash'?
        // Use ?? to provide a fallback or check your DB structure.
        $db_password = isset($row['password']) ? $row['password'] : $row['password_hash'];

        if(password_verify($data->password, $db_password)) {
            // Remove sensitive data
            unset($row['password']); 
            unset($row['password_hash']); 
            
            echo json_encode(["status" => "success", "message" => "Login successful", "doctor" => $row]);
        } else {
            echo json_encode(["status" => "error", "message" => "Invalid password"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "User not found"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Missing email or password"]);
}
?>
